// Add an event listener
document.addEventListener("post.open_booking_modal", function(e) {
    console.log(e.detail);
    if(e && e.detail && e.detail.reservation_id)
    {
        var bookingID = e.detail.reservation_id;
        var bookingRegistrationCard =   '<li class="registration_card_tab">'+
                                            '<a href="#registration_card" data-toggle="tab">'+
                                                'Registration Card'+
                                            '</a>'+
                                        '</li>';
                                        
        // if(innGrid.hasExtensionsPermission == 1) {
            $('ul.left-sidebar').append(bookingRegistrationCard);
        // }

        $('.registration_card_tab').click(function(){
            populateRegistrationCardDDL(bookingID);
        });
    }
});

function populateRegistrationCardDDL(booking_id) {

    var number_of_days = $("[name='number_of_days']").val();
    var pay_period = $("[name='pay_period']").val();

            $.ajax({
                type: "POST",
                url: getBaseURL() + 'booking/get_registration_card_info_AJAX/',
                data: {
                    booking_id: booking_id,
                    number_of_days: number_of_days
                },
                dataType: "json",
                success: function (data) {
                    console.log('data',data);
                    var show_rate = data['company']['show_rate_on_registration_card'];
                    var show_logo = data['company']['show_logo_on_registration_card'];
                    var customer_fields = data['customer_fields'];
                    var booking_fields = data['booking_fields'];
                    var check_in_policies = data['check_in_policies'];
                    var policies = (check_in_policies) ? (check_in_policies.replace(/\n/g, '')) : '';
                    var staying_customers = data['booking']['staying_customers'];
                    var comapany_logo = '';
                    if (show_logo == 1 && data['company_logo'] != "undefined" && data['company_logo'] != null) {
                        comapany_logo = '<img class="img" src="'+innGrid.imageUrl + data['company']['company_id'] + '/' + data['company_logo'] + '" id="company-logo-image"/><br/>';
                    }

                    var company_id = data['company']['company_id'];

                    var balance_due = data['booking']['balance'];

                    var total_tax = data['booking']['total_tax'];
                    total_tax = (total_tax).toFixed(2);

                    if(pay_period == 2)
                        total_tax = (total_tax / 30).toFixed(2);
                    else if(pay_period == 1)
                        total_tax = (total_tax / 7).toFixed(2);

                    var charge_total = data['booking']['charge_total'];
                    charge_total = (charge_total).toFixed(2);

                    console.log('innGrid.isGuestSignEnabled',innGrid.isGuestSignEnabled);

                    var guestSignatureURL = data['guest_signature'];
                    var guestSignatureDate = data['signature_at'] ? data['signature_at'].split(' ')[0] : null;
                    
                    var guestDocuments = data['guest_documents'] || [];

                    var guestIdDocs = [];
                    var creditCardDocs = [];

                    if (Array.isArray(guestDocuments)) {
                        guestDocuments.forEach(function (doc) {
                            if (doc.document_type === 'guest_id') {
                                guestIdDocs.push(doc);
                            } else if (doc.document_type === 'credit_card') {
                                creditCardDocs.push(doc);
                            }
                        });
                    }


                    $('#registration_card').html('');
                    $('#registration_card').append(
                        $("<div/>", {
                            style: 'text-align:right;'
                        })
                            .append(
                                $('<button/>', {
                                    type: 'button',
                                    class: 'btn btn-info btn-sm send_upload_id_link ' + (innGrid.isDocumentDriveEnabled ? '' : 'hidden'),
                                    text: guestDocuments.length
                                        ? l('Update Guest Documents')
                                        : l('Upload Guest Documents'),
                                    style: 'margin: 0px 0px 10px 0px;',
                                    'data-booking_id': data['booking']['booking_id']
                                })
                            ).attr('title', guestDocuments.length
                                ? 'Guest has already uploaded documents. Click to update.'
                                : 'Send link to upload guest documents'
                            )
                            .append(
                                $('<button/>', {
                                    class: 'btn btn-info btn-sm send_sign_link ' + (innGrid.isGuestSignEnabled ? '' : 'hidden'),
                                    text: l('Send'),
                                    style: 'margin: 0px 0px 10px 12px;',
                                    'data-booking_id': data['booking']['booking_id']
                                })
                            )
                            .append(
                                $('<button/>', {
                                    class: 'btn btn-primary btn-sm',
                                    text: l('print'),
                                    style: 'margin: 0px 0px 10px 12px;'
                                }).on('click', function (e) {
                                    $('.full_registration').printThis();
                                })
                            )
                    )
                    $('#registration_card').append(
                        $("<div/>", {
                            class: "row full_registration"
                        })
                            .append(
                                $("<div/>", {
                                    class: 'panel panel-default'
                                })
                                    .append(
                                        $("<div/>", {
                                            class: 'panel-header h3 text-center',
                                            html: comapany_logo
                                        })
                                            .append(
                                                $("<h3/>", {
                                                    class: 'h3',
                                                    text: data['company']['name'] + ' ' + l('Registration Card'),
                                                    style: 'margin-bottom: 0'
                                                })
                                            )
                                            .append(
                                                $("<small/>", {
                                                    class: 'panel-header h3 text-center',
                                                    text: l('Confirmation Number')+': ' + data['booking']['booking_id']
                                                })
                                            )
                                    )
                                    .append(
                                        $("<div/>", {
                                            class: 'panel-body'
                                        })
                                            .append(
                                                $("<div/>", {
                                                    class: 'col-xs-6'
                                                })
                                                    .append(
                                                        $("<strong/>", {
                                                            text: l('Customer information')
                                                        })
                                                    )
                                                    .append(
                                                        $("<table/>", {
                                                            class: 'col-xs-12'
                                                        })
                                                            .append(
                                                                $("<ul/>", {
                                                                    class: 'list-unstyled customer_info'
                                                                })
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Customer Name')+': ' + (typeof (data['customer']) != "undefined" && data['customer'] !== null) ? data['customer']['customer_name'] : ''
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Phone')+': ' + (typeof (data['customer']) != "undefined" && data['customer'] !== null) ? data['customer']['phone'] : ''
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Address')+': ' + (typeof (data['customer']) != "undefined" && data['customer'] !== null) ? (data['customer']['address'] ? data['customer']['address'] : '') : ''
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Email')+': ' + (typeof (data['customer']) != "undefined" && data['customer'] !== null) ? (data['customer']['email'] ? data['customer']['email'] : '') : ''
                                                                        })
                                                                    )
                                                            )
                                                    )
                                            )
                                            .append(
                                                $("<div/>", {
                                                    class: 'col-xs-6 text-right'
                                                })
                                                    .append(
                                                        $("<strong/>", {
                                                            text: l('Booking information')
                                                        })
                                                    )
                                                    .append(
                                                        $("<table/>", {
                                                            class: 'col-xs-12'
                                                        })
                                                            .append(
                                                                $("<ul/>", {
                                                                    class: 'list-unstyled booking_info'
                                                                })
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: $('#RoomSingular').val() + ':' + data['booking']['room_name']
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: $('#RoomType').val() + ':' + data['booking']['room_type_name']
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Check-in Date')+': ' + data['booking']['check_in_date'].split(' ')[0]
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Check-out Date')+': ' + data['booking']['check_out_date'].split(' ')[0]
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Number of Adults')+': ' + data['booking']['adult_count']
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: l('Number of Children')+': ' + data['booking']['children_count']
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: (show_rate == '1') ? (l('Rate')+'*: ' + data['booking']['rate']) : ''
                                                                        })
                                                                    ).append(
                                                                        $("<li/>", {
                                                                            text: (show_rate == '1') ? (l('Tax')+'*: ' + total_tax) : ''
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>", {
                                                                            text: (show_rate == '1') ? (l('Total')+'*: ' + charge_total) : ''
                                                                        })
                                                                    )
                                                                    .append(
                                                                        $("<li/>").html(
                                                                            (show_rate == '1') 
                                                                            ? ('<strong>' + l('Balance Due') + '*:</strong> ' + balance_due) 
                                                                            : ''
                                                                        )
                                                                    )

                                                            )
                                                    )
                                            )
                                            .append(
                                                $("<div/>", {
                                                    class: 'jumbotron registration-policies',
                                                    html: policies
                                                })
                                                    /*
                                                .append(
                                                    $("<div/>", {
                                                        class: 'jumbotron rate_text',
                                                    text: (show_rate == '1') ? ("The rate displayed is the rate for check-in date only. Additional taxes or extra fees may apply.Rates may change during guest's stay due to seasonal rate changes.For a detailed information on rates, please ask receptionist for an invoice.") : ''
                                                    })
                                                )
                                                    */
                                                    .append(
                                                        innGrid.isGuestSignEnabled ? 
                                                        $("<div/>", {
                                                            class: '',
                                                            style: 'padding-top: 20px;'
                                                        }).append(
                                                            $("<label/>", {
                                                                text: l('Signature(s)') + ":"
                                                            })
                                                        ).append(
                                                            guestSignatureURL
                                                                ? $("<img/>", {
                                                                    src: guestSignatureURL,
                                                                    style: 'max-width: 100%; max-height: 150px; border: 1px solid #ccc; display: block; margin-top: 10px;'
                                                                })
                                                                : $("<div/>", {
                                                                    html: `
                                                                        <canvas id="reg-signature-pad" style="border: 2px dashed #ccc; border-radius: 6px; display: block; width: 100%; height: 150px;"></canvas>
                                                                        <div style="margin-top: 10px;">
                                                                            <button id="clear-reg-signature" class="btn btn-warning btn-sm" type="button">Clear</button>
                                                                            <button id="submit-reg-signature" class="btn btn-success btn-sm" type="button">Submit</button>
                                                                        </div>
                                                                    `
                                                                })
                                                        )
                                                    : $("<div/>", {
                                                            class: '',
                                                            style: 'padding-top: 20px;',
                                                            text: l('Signature(s)')+": _______________________________"
                                                        })
                                                    )
                                                    .append(
                                                        innGrid.isGuestSignEnabled ? 
                                                        $("<div/>", {
                                                            class: '',
                                                            style: 'padding-top: 20px;'
                                                        }).append(
                                                        guestSignatureDate ? 
                                                            $("<div/>", {
                                                                class: '',
                                                                style: 'padding-top: 20px;',
                                                                text: l('Date')+": " + guestSignatureDate
                                                            }) 
                                                            : $("<input/>", {
                                                                type: 'date',
                                                                id: 'signature-date',
                                                                name: 'signature_date',
                                                                class: 'form-control',
                                                                style: 'max-width: 250px; margin-top: 5px;',
                                                                value: new Date().toISOString().split('T')[0] // default today
                                                            })
                                                        )
                                                    : $("<div/>", {
                                                            class: '',
                                                            style: 'padding-top: 20px;',
                                                            text: l('Date')+": _______________________________"
                                                        })
                                                    )

                                                    // ---------------- DOCUMENT SECTION ----------------

                                                    .append(
                                                        innGrid.isDocumentDriveEnabled
                                                            ? $("<div/>", { style: "padding-top:20px;" })

                                                                /* ================= GUEST ID ================= */
                                                                .append(
                                                                    $("<label/>", {
                                                                        text: l("Guest ID Cards") + ":",
                                                                        style: "display:block; margin-bottom:10px; font-weight:bold;"
                                                                    })
                                                                )
                                                                .append(
                                                                    guestIdDocs.length
                                                                        ? $("<div/>", { class: "guest-documents-wrapper" }).append(
                                                                            guestIdDocs.map(function (doc) {
                                                                                return $("<img/>", {
                                                                                    src: doc.url,
                                                                              class: "print-guest-document",
                                                                                    "data-type": "guest_id",
                                                                                    style: `
                                                                                        max-width:150px;
                                                                                        max-height:150px;
                                                                                        border:1px solid #ccc;
                                                                                        margin:5px;
                                                                                        cursor:pointer;
                                                                                    `,
                                                                              title: "Click to print Guest ID"
                                                                                });
                                                                            })
                                                                        )
                                                                        : $("<div/>", {
                                                                            text: l("No Guest ID uploaded."),
                                                                            style: "font-style:italic; margin-bottom:15px;"
                                                                        })
                                                                )

                                                                /* ================= CREDIT CARD ================= */
                                                                .append(
                                                                    $("<label/>", {
                                                                        text: l("Guest Credit Cards") + ":",
                                                                        style: "display:block; margin:15px 0 10px; font-weight:bold;"
                                                                          })
                                                                )
                                                                .append(
                                                                    creditCardDocs.length
                                                                        ? $("<div/>", { class: "guest-documents-wrapper" }).append(
                                                                            creditCardDocs.map(function (doc) {
                                                                                return $("<img/>", {
                                                                                    src: doc.url,
                                                                                    class: "print-guest-document",
                                                                                    "data-type": "credit_card",
                                                                                    style: `
                                                                                        max-width:150px;
                                                                                        max-height:150px;
                                                                                        border:1px solid #ccc;
                                                                                        margin:5px;
                                                                                        cursor:pointer;
                                                                                    `,
                                                                                    title: "Click to print Credit Card"
                                                                                });
                                                                            })
                                                                        )
                                                                        : $("<div/>", {
                                                                            text: l("No Credit Card uploaded."),
                                                                            style: "font-style:italic;"
                                                                          })
                                                                )

                                                            : ""
                                                    )


                                            )
                                    )
                            )
                    );

                    // Setup SignaturePad if needed
                    if (!guestSignatureURL) {
                        setTimeout(function () {
                            const canvas = document.getElementById('reg-signature-pad');
                            if (canvas) {
                                const ctx = canvas.getContext('2d');
                                const ratio = window.devicePixelRatio || 1;
                                const rect = canvas.getBoundingClientRect();
                                canvas.width = rect.width * ratio;
                                canvas.height = rect.height * ratio;
                                canvas.style.width = rect.width + 'px';
                                canvas.style.height = rect.height + 'px';
                                ctx.setTransform(1, 0, 0, 1, 0, 0);
                                ctx.scale(ratio, ratio);

                                const signaturePad = new SignaturePad(canvas);

                                $('#clear-reg-signature').on('click', function () {
                                    signaturePad.clear();
                                });

                                $('#submit-reg-signature').on('click', function () {
                                    if (signaturePad.isEmpty()) {
                                        alert('Please provide a signature first.');
                                        return;
                                    }

                                    const dataURL = signaturePad.toDataURL('image/png');

                                    const formData = new URLSearchParams();
                                    formData.append("booking_id", booking_id);
                                    formData.append("company_id", data['company']['company_id']);
                                    formData.append("signature_data", dataURL);

                                    var selectedDate = $('#signature-date').val();

                                    fetch(getBaseURL() + 'public/save_guest_signature', {
                                        method: "POST",
                                        headers: {
                                             "Content-Type": "application/json"
                                        },
                                        body: JSON.stringify({
                                            booking_id: booking_id,
                                            company_id: data['company']['company_id'],
                                            signature_data: dataURL,
                                            signature_date: selectedDate,
                                            signed_via: 'direct'
                                        })
                                    })
                                    .then(res => res.json())
                                    .then(res => {
                                        if (res.status === 'success') {
                                            alert('Signature submitted!');
                                            $('.registration_card_tab').trigger('click');

                                        } else {
                                            alert(res.message);
                                        }
                                    });
                                });
                            }
                        }, 100);
                    }




                    var customers = [];
                    for (var key in staying_customers) {
                        customers.push(staying_customers[key]['customer_name']);
                    }

                    if(company_id == 4093){

                        if (customers) {
                            $('.customer_info').append(
                                $("<li/>", {
                                    text: l('Other guests') + ": " + customers.toString()
                                })
                            );

                            // Add an empty <li> for spacing
                            $('.customer_info').append($("<li/>").html('&nbsp;'));
                        }

                        for (var key in customer_fields) {
                            if (data['customer'] && data['customer']['customer_fields']) {
                                var value = data['customer']['customer_fields'][customer_fields[key]['id']] != null 
                                    ? data['customer']['customer_fields'][customer_fields[key]['id']] 
                                    : '';
                                
                                // Append the field
                                $('.customer_info').append(
                                    $("<li/>").html(
                                        '<b>' + customer_fields[key]['name'] + ': ______________________ ' + value + '</b>'
                                    )
                                );
                                
                                // Add a blank line after each field
                                $('.customer_info').append($("<li/>").html('&nbsp;'));
                            }
                        }

                    } else {
                        if (customers) {
                            $('.customer_info').append(
                                $("<li/>", {
                                    text: l('Other guests')+": " + customers.toString()
                                })
                            )
                        }

                        for (var key in customer_fields) {
                            if (data['customer'] && data['customer']['customer_fields']) {
                                var value = data['customer']['customer_fields'][customer_fields[key]['id']] != null ? data['customer']['customer_fields'][customer_fields[key]['id']] : '';
                                $('.customer_info').append(
                                    $("<li/>", {
                                        text: customer_fields[key]['name'] + ': ' + value
                                    })
                                )
                            }
                        }
                    }

                    for (var key in booking_fields) {
                        var value = data['custom_booking_fields'][booking_fields[key]['id']];
                        if (value) {
                            $('.booking_info').append(
                                $("<li/>", {
                                    text: booking_fields[key]['name'] + ': ' + value
                                })
                            )
                        }
                    }

                    if (show_rate == '0') {
                        $('.rate_text').css('display', 'none');
                    }
                }
            });

        }

$('body').on('click', '.print-guest-document', function (e) {
    e.preventDefault();

    var imgSrc = $(this).attr('src');
    var printWindow = window.open('', '_blank');

    printWindow.document.write(`
        <html>
        <head>
            <title>Print Guest Document</title>
            <style>
                body {
                    margin: 0;
                    padding: 0;
                    text-align: center;
                }
                img {
                    max-width: 100%;
                    max-height: 100vh;
                }
            </style>
        </head>
        <body>
            <img src="${imgSrc}">
            <script>
                window.onload = function () {
                    setTimeout(function () {
                        window.print();
                    }, 500);
                };

                window.onafterprint = function () {
                    window.close();
                };
            </script>
        </body>
        </html>
    `);

    printWindow.document.close();
});
